CREATE TABLE PICTURE (
  id NUMBER(20) NOT NULL ,
  tenant_id NUMBER(20) ,
  remark NVARCHAR2(255) ,
  create_user_id NUMBER(20) ,
  creator NVARCHAR2(255) ,
  create_time DATE ,
  modify_user_id NUMBER(20) ,
  updater NVARCHAR2(255) ,
  modify_time DATE ,
  delete_flag NUMBER(11) ,
  audit_data_version NUMBER(11) ,
  sec_bu_id NUMBER(20) ,
  sec_user_id NUMBER(20) ,
  sec_ou_id NUMBER(20) ,
  pic_name NVARCHAR2(255) ,
  img_alt NVARCHAR2(80) ,
  position NVARCHAR2(20) ,
  pic_type NVARCHAR2(20) ,
  pic_url NVARCHAR2(255) NOT NULL ,
  pic_status NVARCHAR2(20) ,
  pic_sort NUMBER(11) ,
  update_flag NVARCHAR2(20) ,
  link_url NVARCHAR2(255) ,
  link_type NVARCHAR2(40) ,
  pic_color NVARCHAR2(40) ,
  back_pic_name NVARCHAR2(80) ,
  back_pic_addr NVARCHAR2(200) ,
  region NVARCHAR2(100) ,
  ann_begintime DATE ,
  ann_endtime DATE ,
  branch_company NVARCHAR2(100) ,
  tourist_status NVARCHAR2(100)
);
COMMENT ON COLUMN picture.id IS '记录唯一ID';
COMMENT ON COLUMN picture.tenant_id IS '租户ID';
COMMENT ON COLUMN picture.remark IS '备注';
COMMENT ON COLUMN picture.create_user_id IS '记录创建者ID';
COMMENT ON COLUMN picture.creator IS '记录创建者';
COMMENT ON COLUMN picture.create_time IS '记录创建时间';
COMMENT ON COLUMN picture.modify_user_id IS '记录最后更新者ID';
COMMENT ON COLUMN picture.updater IS '记录最后更新者';
COMMENT ON COLUMN picture.modify_time IS '记录最后更新时间';
COMMENT ON COLUMN picture.delete_flag IS '逻辑删除，0：未删除，1：已删除';
COMMENT ON COLUMN picture.audit_data_version IS '锁版本';
COMMENT ON COLUMN picture.sec_bu_id IS 'sec_bu_id';
COMMENT ON COLUMN picture.sec_user_id IS 'sec_user_id';
COMMENT ON COLUMN picture.sec_ou_id IS 'sec_ou_id';
COMMENT ON COLUMN picture.pic_name IS '图片名称';
COMMENT ON COLUMN picture.img_alt IS '缺省标题';
COMMENT ON COLUMN picture.position IS '位置 UDC[SRM:PIC_POSITION]';
COMMENT ON COLUMN picture.pic_type IS '类型';
COMMENT ON COLUMN picture.pic_url IS '地址';
COMMENT ON COLUMN picture.pic_status IS '状态，是否显示';
COMMENT ON COLUMN picture.pic_sort IS '序号';
COMMENT ON COLUMN picture.update_flag IS '是否替代';
COMMENT ON COLUMN picture.link_url IS '跳转链接';
COMMENT ON COLUMN picture.link_type IS '链接类型 UDC[SRM:PIC_LINK_TYPE]';
COMMENT ON COLUMN picture.pic_color IS '颜色';
COMMENT ON COLUMN picture.back_pic_name IS '背景图片名称';
COMMENT ON COLUMN picture.back_pic_addr IS '背景图片地址';
COMMENT ON COLUMN picture.region IS '区域';
COMMENT ON COLUMN picture.ann_begintime IS '广告滚动起始日期';
COMMENT ON COLUMN picture.ann_endtime IS '广告滚动结束日期';
COMMENT ON COLUMN picture.branch_company IS '分公司';
COMMENT ON COLUMN picture.tourist_status IS '游客默认显示状态';
COMMENT ON TABLE picture IS '图片表';